<!DOCTYPE html>
<html lang="sr" dir="ltr">

<head>
  <meta charset="utf-8">
  <title>Life etc</title>
  <link rel="icon" type="image/png" href="/images/favicon.ico">
  <link rel="stylesheet" href="css/main.css">
  <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@500&display=swap" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@500&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
</head>

<body>

  <!-- HEADER -->
  <?php include "header.php"; ?>
  <!-- // HEADER -->
  
  <div class="TL-1">
    <h1>Tretmani Lica</h1>
    <img src="images/facial-treatment.jpg" alt="facial-treatment">
  </div>

  <div class="TL-2">
    <p>Za svaku ženu nega lica bi trebalo da zauzima glavno mesto u nezi kože i tela.</p>
    <p>Međutim, svakodnevno čišćenje lica vodom i kozmetičkim sredstvima (sapun, losion, micelarna voda i sl.) nije dovoljno.</p>
    <p>Kako bi smo kožu lica zaštitile od negativnih uticaja usled izloženosti zagađenju, duvanskom dimu, UV zračenju, šminkanju, vetru i drugim spoljnim štetnim uticajima, i kako bi smo je što duže održale sjajnom, mekom, negovanom i zdravom,
      redovni <strong>kozmetički tretmani</strong> su neizbežni.</p>
    <p>Osim što otklanjaju sve nečistoće, profesionalni tretmani lica dubinski čiste pore, opskrbljuju je svim potrebnim mineralima, poboljšavaju teksturu i čine da lice uvek deluje sveže, odmorno i mlado.</p>
  </div>

  <div class="TL-3">
    <h1>Mi pružamo više različitih tretmana lica, u skladu sa Vašim potrebama:</h1>
    <ol>

      <li>

      <div class="popup_amain">&#x273D; Osnovni ili higijenski tretman
        <button class="opena_popup">+</button>
        <div class="popup_abody">
          <div class="popup_aback"></div>
          <div class="popup_acontain">
            <div class="popup_aclose">x</div>
            <h1>Osnovni ili higijenski tretman</h1>
            <p>
              Ovo je tretman kojim se uglavnom upoznajemo, tretman koji se najčešće radi kod mlade kože.<br><br>
              Sastoji se od pregleda i razgovora o svemu što je za tretman važno, mehaničkog čišćenja, obično dva pilinga i dve maske.<br><br>
              Tačan tok tretmana zavisi od stanja kože.<br><br>
            </p>
            <img src="images/tretman1.jpg" alt="tretman">
          </div>
        </div>
      </div>


      <div class="popup_amain">&#x273D; Biološki tretman lica
        <button class="opena_popup">+</button>
        <div class="popup_abody">
          <div class="popup_aback"></div>
          <div class="popup_acontain">
            <div class="popup_aclose">x</div>
            <h1>Biološki tretman lica</h1>
            <p>
              Glavni cilj biološkog tretmana lica je usporavanje procesa starenja kože, ublažavanje bora i unapređenje tonusa kože. Rezultat biološkog tretmana je hidrirana, elastična, regenerisana koža odmornog izgleda.<br><br>
              Preporučuje se za sve tipove kože u različitom stanju, a poželjno je da se sa ovim tretmanima počne što ranije (oko 25 godine) kako bi se predupredile neželjene pojave. Posebno je pogodan za pušače i osobe koje su često izložene suncu i
              smogu, koje se bore sa pegama i hiperpigmentacijom, ali i za sve ostale. Svaki tretman je invidivualan, prilagođen potrebama klijenta.<br><br>
              Biološki tretman podrazumeva korišćenje preparata koji sadrže visoke koncentracije biološki aktivnih supstanci – voćne i hijaluronske kiseline, vitamina, minerala i drugih hidrirajućih supstanci. U našem salonu se koriste samo
              najkvalitetniji proizvodi najpoznatijih svetskih kozmetičkih kuća.<br><br>
            </p>
            <img src="images/bioloski.JPG" alt="bioloski">
          </div>
        </div>
      </div>

      <div class="popup_amain">&#x273D; Anti-age tretmani
        <button class="opena_popup">+</button>
        <div class="popup_abody">
          <div class="popup_aback"></div>
          <div class="popup_acontain">
            <div class="popup_aclose">x</div>
            <h1>Anti-age tretmani</h1>
            <p>
              U našem salonu možete zakazati sve vrste anti-age tretmana za lice koji doprinose poboljšanju celoukupnog stanja kože tako što je regenerišu, utiču na sve znake starenja i vraćaju koži volumen i sjaj.<br><br>
              U pitanju su invazivniji tretmani namenjeni zrelijoj koži, sa glavnim ciljem da se popune prve dublje bore i finije linije, postigne duboka hidratacija i mlađi izgled kože.<br><br>
              Kontaktirajte nas kako bismo zajedno utvrdili koji tretman bi Vam najviše odgovarao.
            </p>
            <img src="images/anti-age.JPG" alt="anti-age">
          </div>
        </div>
      </div>

      <div class="popup_amain">&#x273D; Mikrodermo abrazija
        <button class="opena_popup">+</button>
        <div class="popup_abody">
          <div class="popup_aback"></div>
          <div class="popup_acontain">
            <div class="popup_aclose">x</div>
            <h1>Mikrodermo abrazija</h1>
            <p>
              Tretman kojim uklanjamo površinski mrtvi sloj kože. To je zapravo mašinski piling.
            </p>
            <img src="images/tretman3.jpg" alt="tretman">
          </div>
        </div>
      </div>

      <div class="popup_amain">&#x273D; Mezoporacija
        <button class="opena_popup">+</button>
        <div class="popup_abody">
          <div class="popup_aback"></div>
          <div class="popup_acontain">
            <div class="popup_aclose">x</div>
            <h1>Mezoporacija</h1>
            <p>
              Postupak ubacivanja mezokoktela u dublje slojeve, bez povrede površinskog sloja kože.
            </p>
            <img src="images/Mezoporacija.jpg" alt="Mezoporacija">
          </div>
        </div>
      </div>
      
<!--<div class="popup_amain">&#x273D; Mezoterapija
        <button class="opena_popup">+</button>
        <div class="popup_abody">
          <div class="popup_aback"></div>
          <div class="popup_acontain">
            <div class="popup_aclose">x</div>
            <h1>Mezoterapija</h1>
            <p>
              Jedan od najmoćnijih tretmana u salonu. Pomoću dermapena ubacujemo aktivne mezokoktele u dublje slojeve kože. Odličan tretman za brze i efektne rezultate.
            </p>
            <img src="images/Mezoterapija.jpg" alt="Mezoterapija">
          </div>
        </div>
      </div>-->
      

      <div class="popup_amain">&#x273D; Radio talasi-RF
        <button class="opena_popup">+</button>
        <div class="popup_abody">
          <div class="popup_aback"></div>
          <div class="popup_acontain">
            <div class="popup_aclose">x</div>
            <h1>Radio talasi - RF</h1>
            <p>
              Postupak zagrevanja tkiva u cilju podsticanja fibroblasta za produkciju novih kolagenih vlakana i zatezanje postojećih. Koristi se samostalno ili u kombinaciji sa drugim tretmanima.<br><br>
              Odlične rezultate daje u tretmanu Biorevitalizacije kože.
            </p>
            <img src="images/radio-talasi.jpg" alt="radio-talasi">
          </div>
        </div>
      </div>

    </li>
    </ol>
  </div>

  <div class="TL-4">
    <div class="inner-width">
      <div class="gallery">

        <a href="images/tretman1.jpg" class="image">
          <img src="images/tretman1.jpg" alt="">
        </a>

        <a href="images/tretman2.jpg" class="image">
          <img src="images/tretman2.jpg" alt="">
        </a>

        <a href="images/tretman3.jpg" class="image">
          <img src="images/tretman3.jpg" alt="">
        </a>

      </div>
    </div>
  </div>

   <!-- HEADER -->
   <?php include "footer.php"; ?>
  <!-- // HEADER -->

  <i class="fa fa-chevron-circle-up" onclick="scrollToTop()" id="scroll-btn" title="Go to top"></i>
  <script src="js/main.js"></script>
  <script>
    $(".opena_popup").click(function() {
      $(this).parent(".popup_amain").children(".popup_abody").addClass("popup_abody_show");
    });
    $(".popup_aclose").click(function() {
      $(".popup_abody").removeClass("popup_abody_show");
    });
    $(".popup_aback").click(function() {
      $(".popup_abody").removeClass("popup_abody_show");
    });
  </script>

  <script>
    $(".gallery").magnificPopup({
      delegate: 'a',
      type: 'image',
      gallery: {
        enabled: true
      }
    });
  </script>

  <script>
    // When the user scrolls down 20px from the top of the document,we will show the button
    window.onscroll = function() {
      if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
        document.getElementById("scroll-btn").style.display = "block";
      } else {
        document.getElementById("scroll-btn").style.display = "none";
      }
    };

    function scrollToTop() {
      document.body.scrollTop = 0; // For Safari
      document.documentElement.scrollTop = 0; // For Chrome, Firefox, IE and Opera
    }
  </script>

</body>

</html>
